<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Generate extends CI_Controller
{
    // construct
    public function __construct()
    {
        parent::__construct();
        // load model
        // $this->load->model('Pdf', 'pdf');
        $this->load->library('numbertowords');
        $this->load->model('Bill_model');
    }
    public function generate_bill()
    {

        $number = $this->input->post('total');
        $word = $this->numbertowords->convert_number(floatval($number));
        $cust_name = $this->input->post('customer');
        $file_name = $cust_name . '-' . time() . '.pdf';

        $data_array = array(
            'customer' => $this->input->post('customer'),
            'invoice_number' => $this->input->post('invoice_number'),
            'bill_date' => $this->input->post('bill_date'),
            'bill_address' => $this->input->post('bill_address'),
            'advance' => $this->input->post('advance') ? number_format($this->input->post('advance'), 2, ".", "") : 0,
            'site' => $this->input->post('site'),
            'subject' => $this->input->post('subject'),
            'gstin' => $this->input->post('gstin'),
            'taxable_total' => $this->input->post('taxable_total'),
            'cgst' => $this->input->post('cgst'),
            'sgst' => $this->input->post('sgst'),
            'total' => $this->input->post('total'),
            'bill_type' => $this->input->post('bill_type'),
            'signature' => @$this->input->post('signature') ? true : false,
            'file_name' => $file_name,
            'save' => 'nott'
        );
        if ($this->input->post('bill_type') !== 'Quotation') {
            $data_array['po_number'] = @$this->input->post('po_number');
            $data_array['po_date'] = @$this->input->post('po_date');
            $data_array['challan_number'] = @$this->input->post('challan_number');
            $data_array['challan_date'] = @$this->input->post('challan_date');
            $data_array['supply'] = @$this->input->post('supply');
        }
        //print_r($data_array);
        $data['bill'] = $data_array;
        $data['counter'] = $this->input->post('append_counter');
        $data['word'] = $word;

        $mpdf = new \Mpdf\Mpdf([
            'mode' => '',
            'format' => 'A4',
            'default_font_size' => 0,
            'default_font' => '',
            'margin_left' => 5,
            'margin_right' => 5,
            'margin_top' => 15,
            'margin_bottom' => 5,
            'margin_header' => 9,
            'margin_footer' => 9,
            'orientation' => 'P',
        ]);
        $this->load->helper(array('form', 'url'));
        $nos = $this->input->post('take_arry');
        $myArray = explode(',', $nos);

        foreach ($myArray as $keys) {
            $data['particular'][] = $this->input->post('particular' . $keys);
            $data['amount'][] = number_format($this->input->post('amount' . $keys), 2, ".", "");
            $data['qty'][] = $this->input->post('qty' . $keys) ? number_format($this->input->post('qty' . $keys), 2, ".", "") : '';
            $data['rate'][] = $this->input->post('rate' . $keys) ? number_format($this->input->post('rate' . $keys), 2, ".", "") : '-';
            $data['hsn'][] = $this->input->post('hsn' . $keys) ? $this->input->post('hsn' . $keys) : '';
            $data['qty_type'][] = $this->input->post('qty_type' . $keys);
        }
        $dos = implode(',', $data['particular']);
        $amount = implode(',', $data['amount']);
        $qty = implode(',', $data['qty']);
        $rate = implode(',', $data['rate']);
        $hsn = implode(',', $data['hsn']);
        $qty_type = implode(',', $data['qty_type']);
        $new_array = array(
            'particular' => $dos, 'amount' => $amount, 'qty' => $qty, 'rate' => $rate, 'hsn' => $hsn,
            'qty_type' => $qty_type
        );
        $data_array = array_merge($data_array, $new_array);
        // var_dump($data_array);
        if (@$this->input->post('edit_bill')) {
            unlink(FCPATH . 'files/' . $this->input->post('file_name'));
            //   $this->Bill_model->delete_by_id($this->input->post('id'));
            $output = $this->Bill_model->update_bill($data_array, $this->input->post('edit_bill'));
        } else {
            $output = $this->Bill_model->add_bill($data_array);
        }

        $html = $this->load->view('bill_create/invoice', $data, true);
        //$output=1;
        if ($output) {
            $mpdf->WriteHTML($html);
            // $mpdf->Output();

            $name = './files/' . $file_name;
            $mpdf->Output($name, 'F');
            // $mpdf->SetHTMLFooter($wat_lagli);
            $data1['file_name'] = $file_name;
            $this->load->view('bill_create/view_bill', $data1);
        } else {
            echo "some error occured";
        }
    }
}
