<?php

class Bill_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	public function add_bill($data = array())
	{
		return $this->db->insert('bills', $data);
	}
	public function get_last_bill()
	{
		$this->db->where('save', 'saved');
		return $this->db->order_by('id', 'desc')->limit(1)->get('bills')->result_array();
		// echo $this->db->last_query(); exit;

	}
	public function count_bill()
	{
		$this->db->where('save', 'saved');
		return $this->db->from("bills")->count_all_results();
	}
	public function get_history()
	{

		$this->db->where('save', 'saved');
		$this->db->order_by("id", "DESC");
		$query = $this->db->get('bills');
		return $query->result_array();
	}

	public function getBillDetails($id)
	{

		$this->db->where('id', $id);
		$query = $this->db->get('bills');
		return $query->row_array();
	}

	//----------------Bill history update------------------///
	public function update_history($id, $data = array())
	{
		$this->db->where('id', $id);
		$this->db->update('bills', $data);
		return $this->db->affected_rows();
	}
	public function update_bill($data = array(), $id)
	{
		$this->db->where('id', $id);
		$this->db->update('bills', $data);
		return $this->db->affected_rows();
	}

	//----------------Bill history update------------------///
	public function save($file)
	{
		$this->db->where('file_name', $file);
		$this->db->update('bills', array('save' => 'saved'));
		return $this->db->affected_rows();
	}

	public function getNotSaved()
	{
		$this->db->where('save', 'nott');
		$query = $this->db->get('bills');
		return $query->result_array();
	}
	public function deleteNotSaved()
	{
		$this->db->where('save', 'nott');
		$this->db->delete('bills');
		return $this->db->affected_rows();
	}
	public function delete_it($file)
	{
		$this->db->where('file_name', $file);
		$this->db->delete('bills');
		return $this->db->affected_rows();
	}

	public function delete_by_id($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('bills');
		return $this->db->affected_rows();
	}

	//----------------Get history by dates------------------///
	public function get_history_by_date($from, $to)
	{
		$this->db->where('bill_date >=', $from);
		$this->db->where('bill_date <=', $to);
		$this->db->where('save', 'saved');
		$this->db->order_by("id", "DESC");
		$query = $this->db->get('bills');
		return $query->result_array();
	}
	//----------------Get history by searched value------------------///
	public function get_history_by_search($table, $search, $vehicle)
	{
		$this->db->where("(`$vehicle` LIKE '%$search%' OR `invoice_number` LIKE '%$search%')");
		$this->db->where('save', 'saved');
		$this->db->order_by("id", "DESC");
		$query = $this->db->get($table);
		return $query->result_array();
	}
	//---------------Login check------------------///
	public function login_check($data = array())
	{
		$this->db->where($data);
		$query = $this->db->get('login');
		return $this->db->affected_rows();
	}
	//---------------get data by cn number------------------///
	public function get_cn_details($data)
	{
		$query = $this->db->get_where('bills', array('cn_number' => $data, 'ftl_box' => 'Part load'))->result();

		return $query;
	}
	//----------------Get get_cn_numbers------------------///
	public function get_cn_numbers()
	{
		$this->db->distinct();
		$this->db->select('cn_number');
		$query = $this->db->get_where('bills', array('cn_number!=' => '', 'ftl_box' => 'Part load'))->result_array();

		//echo $this->db->last_query();
		return $query;
	}
}
